package com.agilex.healthcare.directscheduling.domain;


import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.utility.datemarshallers.DateMarshaller;
import com.agilex.healthcare.utility.datemarshallers.DateTimeMarshaller;
import com.agilex.healthcare.veteranappointment.serializer.JsonDateSerializer;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import gov.va.vamf.videoconnect.common.domain.Appointment;

import javax.xml.bind.annotation.*;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.Date;

/**
 * Created with IntelliJ IDEA.
 * User: patelh
 * Date: 9/5/13
 * Time: 12:45 PM
 * To change this template use File | Settings | File Templates.
 */
@XmlRootElement(name = "bookAppointment", namespace = Namespace.DirectScheduling)
@XmlAccessorType(value = XmlAccessType.NONE)
@XmlType(namespace = Namespace.DirectScheduling)
public class BookAppointment implements Serializable{

    private static final long serialVersionUID = 8375028932202478660L;

    @XmlElement
    private PatientIdentifier patientIdentifier;

    @XmlElement
    private String clinicId;

    @XmlElement
    private String apptLength;

    @XmlElement
    private String bookingNotes;

    @JsonSerialize(using = JsonDateSerializer.class)
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "MM/dd/yyyy HH:mm:ss")
    @XmlElement
    @XmlJavaTypeAdapter(DateTimeMarshaller.class)
    private Date dateTime;

    @XmlElement
    private String purpose;

    @XmlElement
    private String apptType;

    @XmlElement
    private String  purposeSubcategory;

    @XmlElement
    private String lab;

    @XmlElement
    private String xRay;

    @XmlElement
    private String ekg;

    @XmlElement
    private String lvl;

    @JsonSerialize(using = JsonDateSerializer.class)
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "MM/dd/yyyy HH:mm:ss")
    @XmlElement
    @XmlJavaTypeAdapter(DateMarshaller.class)
    private Date desiredDate;
    
    private String error;

    public BookAppointment() {

    }

    public BookAppointment(Appointment appointment) {
        patientIdentifier = new PatientIdentifier(appointment.getPatients().getPatient().get(0).getId().getAssigningAuthority(),
                appointment.getPatients().getPatient().get(0).getId().getUniqueId());
        clinicId = appointment.getPatients().getPatient().get(0).getLocation().getClinic().getIen();
        apptLength = appointment.getDuration().toString();
        bookingNotes = appointment.getBookingNotes();
        purpose = "9";
        apptType = "P";
        purposeSubcategory = "";
        lab = "";
        xRay = "";
        ekg = "";
        lvl = "1";
        dateTime = appointment.getDateTime();
        desiredDate = appointment.getDesiredDate();
    }

    public PatientIdentifier getPatientIdentifier() {
        return patientIdentifier;
    }

    public void setPatientIdentifier(PatientIdentifier patientIdentifier) {
        this.patientIdentifier = patientIdentifier;
    }

    public String getClinicId() {
        return clinicId;
    }

    public void setClinicId(String clinicId) {
        this.clinicId = clinicId;
    }

    public String getApptLength() {
        return apptLength;
    }

    public void setApptLength(String apptLength) {
        this.apptLength = apptLength;
    }

    public String getBookingNotes() {
        return bookingNotes;
    }

    public void setBookingNotes(String bookingNotes) {
        this.bookingNotes = bookingNotes;
    }

    public Date getDateTime() {
        return dateTime;
    }

    public void setDateTime(Date dateTime) {
        this.dateTime = dateTime;
    }

    public String getPurpose() {
        return purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public String getApptType() {
        return apptType;
    }

    public void setApptType(String apptType) {
        this.apptType = apptType;
    }

    public String getPurposeSubcategory() {
        return purposeSubcategory;
    }

    public void setPurposeSubcategory(String purposeSubcategory) {
        this.purposeSubcategory = purposeSubcategory;
    }

    public String getLab() {
        return lab;
    }

    public void setLab(String lab) {
        this.lab = lab;
    }

    public String getxRay() {
        return xRay;
    }

    public void setxRay(String xRay) {
        this.xRay = xRay;
    }

    public String getEkg() {
        return ekg;
    }

    public void setEkg(String ekg) {
        this.ekg = ekg;
    }

    public String getLvl() {
        return lvl;
    }

    public void setLvl(String lvl) {
        this.lvl = lvl;
    }

    public String getError() {
        return error;
    }

    public void setError(String error) {
        this.error = error;
    }

	public Date getDesiredDate() {
		return desiredDate;
	}

	public void setDesiredDate(Date desiredDate) {
		this.desiredDate = desiredDate;
	}
}